; This codes shows how the constract the dynamic dust source, which conclude five main codes.
; The first codes shows how to calculate the surace bareness based on MODIS NDVI. Noteably, the surface bareness (B) is calculated as
; B = (N < thr) / (N total). Therefore the 0.12 in Line 67 can be changed to 0.15, 0.17.
;

; The second main code shows the interpolation for surface bareness

; The thrid main code shows how to calculate the topographical data

; The fourth code show how to calculate the topographical depression features. H=((Zmax-Zi)/(Zmax-Zmin))^5. In the case for 15° * 15°, the Lines 186-194 should be changed
; to h=new((/3300,6900/),float)
;   do q = 0,3299
;    do p = 0,6899
;      if (.not.ismissing(max(fn(q:299+q,p:299+p))-min(fn(q:299+q,p:299+p))).and.(max(fn(q:299+q,p:299+p))-min(fn(q:299+q,p:299+p))).ne.0.0) then
;        h(q,p)= ((max(fn(q:299+q,p:299+p))-fn(q+150,p+150))/(max(fn(q:299+q,p:299+p))-min(fn(q:299+q,p:299+p))))^5
;       else
;         h(q,p)=h@_FillValue 
;       end if
;end do
;end do

;in Lines 198-199: 
;h&lat=fspan(-82.45,82.45,3300)
;h&lon=fspan(-172.45,172.45,6900)

; The fifth code shows how to construct the dynamic dust source

; The sxith code shows how to constrain the dynamic dust source based on land cover and snowcovr
; The following are the specific information for the dynamic dust source construction.




;First, calculate the surface bareness
begin

  setvalues NhlGetWorkspaceObjectId()
    "wsMaximumSize" : 500000000
  end setvalues

  ;Due to the computer memory, we calculated the surface bareness from 2001 to 2020 in four separate groups(2001-2005,2006-2010,2011-2015,2016-2020).
  path="/home/sharedata/csr4/zhangyue/MODIS/NDVI_2016-2020/"
  filename="MOD13C2.A20*"
  outfiles=systemfunc("ls "+path+filename)
  f=addfiles(outfiles+".hdf","r")
  ListSetType(f,"join")
  printVarSummary(f)

;::::::::::::Reading the NDVI :::::::::::::::::::::::::::::::::::::::::::::::::::::
  fn=short2flt(f[:]->CMG_0_05_Deg_Monthly_NDVI)
  printVarSummary(fn)
  xfn=new((/60,3600,7200/),float)
  xfn=where(fn.ge.0,0.00000001*fn,fn@_FillValue)
  printVarSummary(xfn)
  b=new((/60,360,720/),float)
;;;;Calculating the surface bareness (B) ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  do p = 0,59  
  do k=0,359
  do m=0,719
   c=0.0
   d=0.0
    do i=10*k,9+10*k
      do j=10*m,9+10*m
      if(.not.ismissing(xfn(p,i,j)))then
      c:=c+1
      end if
      if(.not.ismissing(xfn(p,i,j)).and.xfn(p,i,j).lt.0.12) then
        d:=d+1
        end if
     end do
   end do
if (c.eq.0) then
b(p,k,m)=0.0
end if
if (c.ne.0) then
b(p,k,m)=1.0*d/c
end if
end do
end do
end do

;;;;;;;Giving B latitude and longitude ;;;;;;;;;;;;;;;;
b!0="time"
b!1="lat"
b!2="lon"
b&lat=fspan(89.75,-89.75,360)
b&lon=fspan(-179.75,179.75,720)
b&lat@units="degrees_north"
b&lon@units="degrees_east"
;;;;Removing the B on the ocean ;;;;;;;;;;;
a=addfile("$NCARG_ROOT/lib/ncarg/data/cdf/landsea.nc","r")
lsdata=a->LSMASK
lsm_b=landsea_mask(lsdata,b&lat,b&lon)
b=mask(b,lsm_b.eq.0,False);Removing the B on the ocean
outfile="B_0.5_0.12_16-20.nc";Outputing the B to a nc file
fout=addfile(outfile,"c")
fout->B=b
printVarSummary(b)
end

;;;;;;;Second: surface bareness interpolation (from the obtained surface bareness in the last 20year in the first step) ;;;;;;;;;;;;;;;;;;;;;;;;
begin

in=addfile("/home/user/chensy3/csr4/zhangyue/wrfdata/wrfout/geo/B/B_0.5_0.12.nc","r")
n=in->B
printVarSummary(n)

xb=new((/240,3600,7200/),float)

do m = 0,239
do i=0,359
  do j=0,719
  xb(m,10*i:9+10*i,10*j:9+10*j)=n(m,i,j)
  end do
end do
end do

printVarSummary(xb)

fx=new((/240,3400,7000/),float)
fx = xb(:,100:3499,100:7099)

printMinMax(fx,False)

fx!0="Time"
fx!1="lat"
fx!2="lon"
fx&lat=fspan(84.75,-84.75,3400) ;++++++++++++++++
fx&lon=fspan(-174.75,174.75,7000)
fx&lat@units="degrees_north"
fx&lon@units="degrees_east"
printVarSummary(fx)

setfileoption("nc","Format","NetCDF4")
outfile="B_0.05_0.12_10.nc";Outputing B ;;;;
fout=addfile(outfile,"c")
fout->B=fx
printVarSummary(fx)

end

;;;Thrid: Calculating the topographical data ;;;;;
begin

inin=addfile("/home/user/chensy3/data/zhangyue/ncl//data_landcover/GRIDONE_2D.nc","r")
n=inin->elevation
fn=short2flt(n)
printVarSummary(fn)
;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

  h=new((/3600,7200/),float)
  h_qu=new((/3601,7201/),float)

;The following shows how to calculated H:::::::::::::::::::::::::::::::::::::::::::::::::::

  h_qu=fn(::3,::3)
    h=h_qu(0:3599,0:7199)

;;Giving the latitude and longitude for H;;;
h!0="lat"
h!1="lon"
h&lat=fspan(-89.95,89.95,3600)
h&lon=fspan(-179.95,179.95,7200)
h&lat@units="degrees_north"
h&lon@units="degrees_east"
;print(h)
;;;;Removing the h on the ocean;;;;
a=addfile("$NCARG_ROOT/lib/ncarg/data/cdf/landsea.nc","r")
lsdata=a->LSMASK
lsm_b=landsea_mask(lsdata,h&lat,h&lon)
h=mask(h,lsm_b.eq.0,False)
outfile="h_quzhi_0.5.nc"
fout=addfile(outfile,"c")
fout->H=h
printVarSummary(h)
end

;;;Fourth: Calculating the topographical depression features;;;;;;;;;; 
begin

inin=addfile("/home/user/chensy3/csr4/zhangyue/wrfdata/wrfout/geo/H/h_quzhi_0.05.nc","r")
fn=inin->H
h=new((/3400,7000/),float)
;;;;Calculating the topographical depression features;;;;;;;;
    
   do q = 0,3399
    do p = 0,6999
      if (.not.ismissing(max(fn(q:199+q,p:199+p))-min(fn(q:199+q,p:199+p))).and.(max(fn(q:199+q,p:199+p))-min(fn(q:199+q,p:199+p))).ne.0.0) then
        h(q,p)= ((max(fn(q:199+q,p:199+p))-fn(q+100,p+100))/(max(fn(q:199+q,p:199+p))-min(fn(q:199+q,p:199+p))))^5
       else
         h(q,p)=h@_FillValue 
       end if
end do
end do
;;Giving the latitude and longtitude for H ;;;;;;;;;
h!0="lat"
h!1="lon"
h&lat=fspan(-84.95,84.95,3400)
h&lon=fspan(-174.95,174.95,7000)
h&lat@units="degrees_north"
h&lon@units="degrees_east"
;::::::::::::::::::::::::::::::::::::::::
outfile="h_10_0.5.nc";输出b值
fout=addfile(outfile,"c")
fout->H=h
printVarSummary(h)
end

;;;;;;;Fifth:  Calculating the Dynamic Dust Source  ;;;;;;;;;;;;;;;;;;
begin
inin=addfile("/home/user/chensy3/csr4/zhangyue/wrfdata/wrfout/geo/H/H_0.05_10.nc","r")
fn=inin->H
printVarSummary(fn)

in=addfile("/home/user/chensy3/csr4/zhangyue/wrfdata/wrfout/geo/B_qushi/B_0.05_0.12_10.nc","r")
n=in->B
fx=n(:,::-1,:)
printVarSummary(fx)

s=new((/240,3400,7000/),float)
do i=0,239
s(i,:,:)=fn(:,:)*fx(i,:,:)
end do

s!0="Time"
s!1="lat"
s!2="lon"
s&lat=fspan(-84.75,84.75,3400)
s&lon=fspan(-174.75,174.75,7000)
s&lat@units="degrees_north"
s&lon@units="degrees_east"
printVarSummary(s)

setfileoption("nc","Format","NetCDF4")
outfile="s_0.05_0.12_10.nc";输出h值
fout=addfile(outfile,"c")
fout->S=s
end

;;;;;Sixth  Constraining the dynamic dust source by landcover data ;;;;;;;;;;
begin

setfileoption("nc", "FileStructure", "Advanced")

inin=addfile("/home/user/chensy3/csr4/zhangyue/wrfdata/wrfout/geo/BxH/s_0.05_0.12_10.nc","r")
b=inin->S
printVarSummary(b)

  setvalues NhlGetWorkspaceObjectId()
    "wsMaximumSize" : 900000000
  end setvalues

setfileoption("nc", "Format",  "NetCDF4")

s=new((/240,3600,7200/),float)
do m =0,239
 do i =0,99
  do j=0,99
     s(m,i,j)=s@_FillValue
  end do
 end do
end do

s(:,100:3499,100:7099)=b(:,0:3399,0:6999)

do n =0,239
 do p =3500,3599
  do q=7100,7199
     s(n,p,q)=s@_FillValue
  end do
 end do
end do

s!0="Time"
s!1="lat"
s!2="lon"
s&lat=fspan(-90,90,3600)
s&lon=fspan(-180,180,7200)
s&lat@units="degrees_north"
s&lon@units="degrees_east"
printVarSummary(s)
s1 = s(:,::-1,:)

path="/home/sharedata/csr4/zhangyue/MODIS/landcover/"
filename="MCD12C1.A20*"
outfiles=systemfunc("ls "+path+filename)
in=addfiles(outfiles+".hdf","r")
ListSetType(in,"join")
printVarSummary(in)
landcover=in[:]->Majority_Land_Cover_Type_1
printVarSummary(landcover)

path1="/home/sharedata/csr4/zhangyue/MODIS/SNOW_COVER/"
filename1="MOD10CM.A20*"
outfiles1=systemfunc("ls "+path1+filename1)
sc=addfiles(outfiles1+".hdf","r")
ListSetType(sc,"join")
printVarSummary(sc)
sonwcover=sc[:]->Snow_Cover_Monthly_CMG
printVarSummary(sonwcover)


;;;;;; The dynamic dust source is contrained by land cover and snow cover
s1=where(landcover.eq.16.or.landcover.eq.10.or.landcover.eq.12.or.landcover.eq.14.or.landcover.eq.9.or.landcover.eq.7,s1,s1@_FillValue)
s1=where(sonwcover.eq.0,s1,s1@_FillValue)

;Giving the latitude and longtitude information for the contrained S  ;;;;;;;
s1!0="time"
s1!1="lat"
s1!2="lon"
s1&time=ispan(0,239,1)
s1&lat=fspan(90,-90,3600)
s1&lon=fspan(-180,180,7200)
s1&time@units="monthy"
s1&lat@units="degrees_north"
s1&lon@units="degrees_east"
printVarSummary(s1)

lat  = s1&lat
lon  = s1&lon
time = s1&time

  fout = addfile("s_0.05_0.12_10.nc","c")
  setfileoption(fout,"DefineMode",True)

  fileAtt = True
  fileAtt@creation_data = (/"s1","lat","lon","time"/)

  dimNames=(/"time","lat","lon"/)
  dimSizes=(/dimsizes(time),dimsizes(lat),dimsizes(lon)/)
  dimUnlim=(/False,False,False/)
  filedimdef(fout,dimNames,dimSizes,dimUnlim)
  

  filevardef(fout,"time",typeof(time),getvardims(time))
  filevardef(fout,"lat",typeof(lat),getvardims(lat))
  filevardef(fout,"lon",typeof(lon),getvardims(lon))
  filevardef(fout,"s1",typeof(s1),getvardims(s1))
  
  filevarattdef(fout,"s1",s1)
  filevarattdef(fout,"lat",lat)
  filevarattdef(fout,"lon",lon)
  filevarattdef(fout,"time",time)

  fout->time  =(/time/)
  fout->lon =(/lon/)
  fout->lat =(/lat/)
  fout->s1=(/s1/)
  
end